// $Id: CFontReference.cpp,v 1.5 2007/02/08 21:07:54 paul Exp $

/*
 * All contents of this source code are copyright 2005 Exp Digital Uk.
 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy
 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
 * All content is the Intellectual property of Exp Digital Uk.
 * Certain sections of this code may come from other sources. They are credited where applicable.
 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
 */

#include "CFontReference.hpp"
using Exponent::GUI::Fonts::CFontReference;

//	===========================================================================
EXPONENT_CLASS_IMPLEMENTATION(CFontReference, CCountedObject);

//	===========================================================================
CFontReference::CFontReference(const CString &name, const CString &facename) : m_name(name), m_facename(facename)
{
	EXPONENT_CLASS_CONSTRUCTION(CFontReference);
	this->setName(name);
	this->setFacename(facename);
}

//	===========================================================================
CFontReference::CFontReference(const CFontReference &reference)
{
	EXPONENT_CLASS_CONSTRUCTION(CFontReference);
	this->setName(reference.getName());
	this->setFacename(reference.getFacename());
}

//	===========================================================================
CFontReference::~CFontReference()
{
	EXPONENT_CLASS_DESTRUCTION(CFontReference);
}

//	===========================================================================
CFontReference &CFontReference::operator = (const CFontReference &reference)
{
	this->setName(reference.getName());
	this->setFacename(reference.getFacename());
	return (*this);
}